﻿/**********************************
* @file timer2.h
* @brief
* @author
* @version V0.0.0
* @date 2020.02.18
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _TIMER2_H
#define  _TIMER2_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU38F20.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def TIMER2_COUNT
* @brief define TIMER2 COUNT
* Details.
*/
#define TIMER2_COUNT			(250-1)

/**
* @def TIMER2_PWM_DUTY_50
* @brief define pwm 50% duty
* Details.
*/
#define TIMER2_PWM_DUTY_50		(125-1)



/* Fuction Define -----------------------------------------------------------*/

/**
* @def timer2_enable()
* @brief set timer2 enable
* Details.
*/
#define timer2_enable()     {T2EN = 1;}

/**
* @def timer2_div_32()
* @brief set timer2 div 32
* Details.
*/
#define timer2_div_32()          {T2RATE_0 = 1;T2RATE_1 = 0;T2RATE_2 = 1;T2RATE_3 = 0;}

/**
* @def timer2_clk_source()  
* @brief timer2 clock source select
* Details.
*/
#define timer2_clk_source()        {T2CKS = 0;}

/**
* @def timer2_count_clr()  
* @brief timer2 count clear
* Details.
*/
#define timer2_count_clr()        {T2RSTB = 0;}


/**
* @def timer2_int_enable()  
* @brief enable timer2 int 
* Details.
*/
#define timer2_int_enable()       {TM2IF = 0; TM2IE = 1;GIE = 1;}


/* Exported functions 
--------------------------------------------------------*/

extern void timer2_init(void);
extern void timer2_set_pwm_period(unsigned int period);
extern void timer2_set_pwm_duty(unsigned int duty);


#endif